#!/usr/bin/env python
# author: David D Lowe
# year: 2009
# this file has been released into the public domain

from distutils.core import setup
import os, sys
import glob


def main():
    
    data_files = glob.glob("files/*")  # data_files a list of strings
    # of the relative paths of all non-py files that should be included
    # ex: data_files is ['files/pulseoptions.glade', 'settings.xml', ...]
    
    setup( name="earcandy", # this should start with a lowercase letter 
        #so that it can be used as a debian package name later on
    version="0.4", # string, version of your program, not python version
    description="A sound level manager that nicely fades applications in and out based on their profile and window focus", # short
    author="KillerKiwi",
    author_email="killerkiwi2005@gmail.com",
    url="https://launchpad.net/earcandy", # home page for end-users
    license="unknown",
    packages=["ear_candy", "ear_candy.pulseaudio", "ear_candy.window"], # python packages, not debian packages
    data_files=[('share/earcandy', data_files),
      ('/usr/share/applications', ['files/earcandy.desktop']),
      ('/usr/share/pixmaps', ['files/earsLabel.png'])], # data_files is a list of tuples
            # each tuple contaning an installation path and a list of data files
    scripts=["runner/ear_candy"], # the script that should be run and installed in /usr/bin
    classifiers=["Development Status :: 5 - Production/Stable", "Intended Audience :: End Users/Desktop", "License :: unknown", "Operating System :: POSIX :: Linux"],
        # a bunch of optional tags, a list of classifiers can be found at http://pypi.python.org/pypi?:action=list_classifiers
    long_description="""A sound level manager that nicely fades applications in and out based on there profile and window focus

What works now :
 - All volume adjustments are fades
 - Fade out music/video players on skype call
 - Fade to music player with focus when more than one
 - Fade out music player when video playing
 - Push sound to USB headsets on plugin
 - Categories to assign to clients
 - Sniffs desktop files to guess application category ... music/video/VoIP
 - Simplified pref UI for creating rules
 - Volume sniffing to fix youtube video issue""")

if __name__ == "__main__":
    main()  
